/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.TagPredicate;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record PotionFluidEffect(float effectScale, TagPredicate predicate) implements ISpillingEffect
{
    public static final class_2960 ID = TConstruct.getResource("potion_fluid");
    public static final JsonDeserializer<PotionFluidEffect> LOADER = (element, type, context) -> {
        JsonObject json = element.getAsJsonObject();
        float scale = class_3518.method_15259((JsonObject)json, (String)"scale");
        TagPredicate predicate = TagPredicate.ANY;
        if (json.has("predicate")) {
            predicate = TagPredicate.deserialize(json.get("predicate"));
        }
        return new PotionFluidEffect(scale, predicate);
    };

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        class_1842 potion;
        class_1309 target = context.getLivingTarget();
        class_1309 attacker = context.getAttacker();
        if (target != null && this.predicate.test(fluid.getTag()) && (potion = class_1844.method_8057((class_2487)fluid.getTag())) != class_1847.field_8984) {
            int oldInvulnerableTime = target.field_6008;
            float totalScale = scale * this.effectScale;
            for (class_1293 instance : potion.method_8049()) {
                class_1291 effect = instance.method_5579();
                if (effect.method_5561()) {
                    target.field_6008 = 0;
                    effect.method_5564((class_1297)attacker, (class_1297)attacker, target, instance.method_5578(), (double)totalScale);
                    continue;
                }
                int duration = (int)((float)instance.method_5584() * totalScale);
                if (duration <= 10) continue;
                target.method_6092(new class_1293(effect, duration, instance.method_5578(), instance.method_5591(), instance.method_5581(), instance.method_5592()));
            }
            target.field_6008 = oldInvulnerableTime;
        }
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("scale", (Number)Float.valueOf(this.effectScale));
        if (this.predicate != TagPredicate.ANY) {
            json.add("predicate", this.predicate.serialize());
        }
        return json;
    }
}

